/* Marquage des points avec effets sonores
Version fraançaise de Big Adventure Marble Maze Part 1
*/
/*Big Adventure Marble Maze Game Part 1, First Section
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 6 piezos
 * 6 10 MOhm resistors

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */

// Les variables pour les broches
int brochesPoints[] = {A0, A1, A2, A3, A4};

// Le nombre de capteurs pour le score
int nombrebrochesPoints = 5;

// Le seuil de déclenchement des capteurs piézoélectriques
int seuilPiezo = 800 ;

int brocheHautParleur = 9 ;

// setup() s’exécute une fois quand la carte est alimentée
// ou après avoir appuyé sur le bouton Reset
void setup() {
  Serial.begin(9600);
}
// loop() s’exécute de façon continue après la fonction setup()
void loop() {
  int i;
  for( i=0; i<nombrebrochesPoints; i++ ) {
    int valeurBroche = analogRead(brochesPoints[i]);
    // Si la valeur ci-dessus est supérieure au seuil défini
    if( valeurBroche > seuilPiezo) {
      // Afficher le numéro de la broche et la valeur lue
      Serial.print("Capteur : ");
      Serial.print(i);
      Serial.println(" Valeur : ");
      Serial.println(valeurBroche);
      
      // Produire une tonalité sonore
      tone(brocheHautParleur, 659, 300) ;
      delay(300) ;
      
      // Pause évitant à la bille de marquer le score
      // plusieurs fois
      delay(300) ;
    }
  }
}
